package it.eng.eremita.jpa.manager;

import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import graphql.servlet.GraphQLContext;
import it.eng.eremita.graphql.types.SessionProvider;
import it.eng.eremita.jpa.entity.Config;
import it.eng.eremita.jpa.entity.Permesso;
import it.eng.eremita.jpa.entity.Ruolo;
import it.eng.eremita.jpa.entity.Utente;

public class Accessor {
	
	public static final String eremitaManagerJndi = "java:app/LifeEremitaEJB/EremitaManager";
	

	
	public static EremitaManager getEremitaManager() {
		

		
		try {
			InitialContext ic = new InitialContext();
			//Retrieve the Home interface using JNDI lookup
			EremitaManager em = (EremitaManager) ic.lookup(eremitaManagerJndi);
			//System.out.println("EremitaManager = "+er);
			return em;
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("EremitaManager = ERROR");
			return null;
		}
		
	}
	
	public static Utente getUtenteAttuale(HttpServletRequest request) {
		//return (Utente)getEremitaManager().getById(Utente.class, "FVNGPR81P12G467R");
		if (request==null) return null;
		
		if (request.getHeader("codicefiscale")!=null) {
			return (Utente)getEremitaManager().getById(Utente.class, request.getHeader("codicefiscale")); 
		} else return (Utente)getEremitaManager().getById(Utente.class, "FVNGPR81P12G467R");
		
		/*HttpSession session= request.getSession(true);
		//System.out.println("GETUTENTEATTUALE"+session);
		if (session==null) return null;
		Utente u = (Utente)session.getAttribute("USER_PROFILE");
		return getEremitaManager().getById(Utente.class, u.getId());*/
		//return u;
	}
	
	public static Utente getUtenteAttuale(SessionProvider ctx) {
		//return (Utente)getEremitaManager().getById(Utente.class, "FVNGPR81P12G467R");
		if (ctx==null) return null;
		HttpServletRequest request = ctx.getRequest();
		return getUtenteAttuale(request);
	}
	
	public static void setUtenteAttuale(HttpServletRequest request, Utente u) {
		HttpSession session= request.getSession(true);
		System.out.println("SETUTENTEATTUALE "+session+" "+u.getId());
		session.setAttribute("USER_PROFILE", u);
	}
	
	public static void setUtenteAttuale(HttpServletRequest request, String cf) {
		Utente u = getEremitaManager().getById(Utente.class, cf);
		setUtenteAttuale(request,u);
	}
	
	public static boolean haPermesso(Utente u,String permesso) {
		if (u==null) return false;
		Ruolo r = u.getRuolo();
		if (r==null) return false;
		for (Permesso p : r.getPermessi()) {
			if (p.getId().equals(permesso) || p.getId().equals("PERMESSO_TUTTO")) return true;
		}
		
		return false;
		
	}
	
	public static String getAmbiente() {
		Config c = (Config)getEremitaManager().getById(Config.class, "AMBIENTE");
		if (c==null) return "SCONOSCIUTO";
		return c.getValore();
	}
	
	public static boolean utentiOspiti() {
		Config c = (Config)getEremitaManager().getById(Config.class, "OSPITI");
		if (c==null) return false;
		return "true".equals(c.getValore());
	}

}
